*** Table 6:  Evidence from Northern Newspapers: Cross-sectional Regressions

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


*** OPEN NEWSPAPERS dataset
use  "$data/main_newspapers.dta", clear

egen cst=group(statefip countyicp)
sort cst week keyword_victim keyword_place


gen POST=0
replace POST=1 if week>-1

foreach i in ///
LD_Z_p40  LD_fr_black D6040_fr_black Z_40to60_p40 fr_black_40 D_fr_black_in40 D_fr_black_in50 Z_p40_in40 Z_p40_in50 {
    
gen `i'_P=`i'*POST

}
.

egen stateweek=group(statefip week)
egen keyword_joint=group(victim_id  place_id)

compress

distinct cst //492 counties for which we have np data 

**************************************************************
cd "$output"
 
* col. 1 
ivreghdfe any_mention (D6040_fr_black=Z_40to60_p40)  [aw=totpop_40]  if POST==1 , a(statefip keyword_joint week) cluster(cst) savefirst
local F=e(widstat)
outreg2 using Table6.xls, excel nocon replace ///
keep ( D6040_fr_black)  dec(3) addstat( "F-stat", `F')  ///
addtext(State FE, X, Episode FE, X, Week FE, X, Weights, Pop 1940, Sample, 1940+, Weeks, 0 to +26)

est restore _ivreg2_D6040_fr_black
outreg2 using Table6_B.xls, excel nocon replace ///
keep (Z_40to60_p40)  dec(3)


* col. 2
ivreghdfe any_mention (D6040_fr_black=Z_40to60_p40)  [aw=totpop_40]  if POST==1 & year<1945 , a(statefip keyword_joint week) cluster(cst) savefirst
local F=e(widstat)
outreg2 using Table6.xls, excel nocon append ///
keep ( D6040_fr_black)  dec(3) addstat( "F-stat", `F')  ///
addtext(State FE, X, Episode FE, X, Week FE, X, Weights, Pop 1940, Sample, 1940-44, Weeks, 0 to +26)


est restore _ivreg2_D6040_fr_black
outreg2 using Table6_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)


* col. 3
ivreghdfe any_mention (D6040_fr_black=Z_40to60_p40)  [aw=totpop_40]  if POST==1 & year>1944, a(statefip keyword_joint week) cluster(cst) savefirst
local F=e(widstat)
outreg2 using Table6.xls, excel nocon append ///
keep ( D6040_fr_black)  dec(3) addstat( "F-stat", `F')  ///
addtext(State FE, X, Episode FE, X, Week FE, X, Weights, Pop 1940, Sample, 1945+, Weeks, 0 to +26)

est restore _ivreg2_D6040_fr_black
outreg2 using Table6_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)


* col. 4
ivreghdfe any_mention (D6040_fr_black=Z_40to60_p40)  [aw=totpop_40]  if POST==1 & year>1949, a(statefip keyword_joint week) cluster(cst) savefirst
local F=e(widstat)
outreg2 using Table6.xls, excel nocon append ///
keep ( D6040_fr_black)  dec(3) addstat( "F-stat", `F')  ///
addtext(State FE, X, Episode FE, X, Week FE, X, Weights, Pop 1940, Sample, 1950+, Weeks, 0 to +26)

est restore _ivreg2_D6040_fr_black
outreg2 using Table6_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)


* col. 5 
ivreghdfe any_mention (D6040_fr_black=Z_40to60_p40)  [aw=totpop_40]  if POST==1 & year>1954, a(statefip keyword_joint week) cluster(cst) savefirst
local F=e(widstat)
outreg2 using Table6.xls, excel nocon append ///
keep ( D6040_fr_black)  dec(3) addstat( "F-stat", `F')  ///
addtext(State FE, X, Episode FE, X, Week FE, X, Weights, Pop 1940, Sample, 1955+, Weeks, 0 to +26)

est restore _ivreg2_D6040_fr_black
outreg2 using Table6_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)


